/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class Sash extends Control {

public Sash (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Selection,typedListener);
	addListener (SWT.DefaultSelection,typedListener);
}

static int checkStyle (int style) {
	return checkBits (style, SWT.HORIZONTAL, SWT.VERTICAL, 0, 0, 0, 0);
}

void hookEvents () {
	super.hookEvents();
//	_hookEvents("onmouseup",	SWT.Selection);
	_hookSetValue("onmousedown", SWT.Selection);
}

public void removeSelectionListener (SelectionListener listener) {
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.Sash"]){
		$wnd.dojo._hasResource["org.eclipse.swt.Sash"] = true;
		$wnd.dojo.provide("org.eclipse.swt.Sash");
		
		$wnd.dojo.require("dijit.form._FormWidget");
	
		$wnd.dojo.declare("org.eclipse.swt.Sash", $wnd.dijit.form._FormWidget, {
			isSmooth: false,
			isHorizontal: true,
			parentOffset: {x: 0, y: 0},
			templateString: '<div dojoAttachPoint="focusNode"></div>',
			attributeMap: $wnd.dojo.mixin($wnd.dojo.clone($wnd.dijit.form._FormWidget.prototype.attributeMap),{}),
			beginSizing: function(e){
				this.parentOffset = $wnd.swt.getPosition(this.domNode.parentNode);
				if(!this.cover){
					this.cover = $wnd.dojo.doc.createElement('div');
					this.domNode.parentNode.appendChild(this.cover);
					$wnd.swt.setNativeBounds(this.cover, {t:0, l:0});
					$wnd.swt.setCssStyle(this.cover, {
						height: "100%",
						position: "absolute",
						width: "100%",
						zIndex: "1"
					});
				} else {
					$wnd.swt.setCssStyle(this.cover, {zIndex: "1"});
				}
				$wnd.swt.setCssStyle(this.domNode, {zIndex: "2"});
				
				this._connects = [];
				this._connects.push($wnd.dojo.connect($doc.documentElement, "onmousemove", this, "changeSizing"));
				this._connects.push($wnd.dojo.connect($doc.documentElement, "onmouseup", this, "endSizing"));
				$wnd.dojo.stopEvent(e);
			},
			changeSizing: function(e){
				if(this.isHorizontal){
					$wnd.swt.setNativeBounds(this.domNode, {t: e.pageY - this.parentOffset.y - this.domNode.offsetHeight/2});
				}else{
					$wnd.swt.setNativeBounds(this.domNode, {l: e.pageX - this.parentOffset.x - this.domNode.offsetWidth/2});
				}
				if(this.isSmooth){
					this.update(e);
				}
				$wnd.dojo.stopEvent(e);
			},
			endSizing: function(e){
				this.update(e);
				if(this.cover){
					$wnd.swt.setCssStyle(this.cover, {zIndex: "-1"});
				}
				$wnd.dojo.forEach(this._connects, $wnd.dojo.disconnect);
				$wnd.dojo.stopEvent(e); 
			},
			postCreate: function(){
				this.className = this.isHorizontal ? 'dijitSplitContainerSizerV' : 'dijitSplitContainerSizerH';
				$wnd.dojo.addClass(this.domNode, this.className);
				this.inherited("postCreate",arguments);
			},
			resize: function(){},
			setWidgetBounds: function(dim){
				$wnd.swt.setNativeBounds(this.domNode, dim);
			},
			update: function(e, offset){
				var style = @org.eclipse.swt.SWT::Selection;
				var event = this.self.@org.eclipse.swt.widgets.Widget::getEvent()();
				event.@org.eclipse.swt.widgets.Event::type = style;
				if (this.isHorizontal) {
					event.@org.eclipse.swt.widgets.Event::x = 0;
					event.@org.eclipse.swt.widgets.Event::y = e.pageY - this.parentOffset.y - this.domNode.offsetHeight/2;
					event.@org.eclipse.swt.widgets.Event::height = this.domNode.clientHeight;
					event.@org.eclipse.swt.widgets.Event::width = this.domNode.clientWidth;
				} else {
					event.@org.eclipse.swt.widgets.Event::x = e.pageX - this.parentOffset.x - this.domNode.offsetWidth/2;
					event.@org.eclipse.swt.widgets.Event::y = 0;
					event.@org.eclipse.swt.widgets.Event::height = this.domNode.clientHeight;
					event.@org.eclipse.swt.widgets.Event::width = this.domNode.clientWidth;
				}
				this.self.@org.eclipse.swt.widgets.Widget::sendEvent(ILorg/eclipse/swt/widgets/Event;)(style, event);
			}
		});
	}
	var params = {};
	if((style & (@org.eclipse.swt.SWT::BORDER)) != 0){
		params.border = "1px solid black";
	}
	if((style & (@org.eclipse.swt.SWT::SMOOTH)) != 0){
		params.isSmooth = true;
	}
	if((style & (@org.eclipse.swt.SWT::HORIZONTAL)) != 0){
		params.isHorizontal = true;
	} 
	else if((style & (@org.eclipse.swt.SWT::VERTICAL)) != 0){
		params.isHorizontal = false;
	}
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	var self = new $wnd.org.eclipse.swt.Sash(params);
	try {
		this.@org.eclipse.swt.widgets.Widget::jsObject = self;
		jsParent.addChild(self);
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _hookSetValue (String eventType,  int style) /*-{
	var self = this.@org.eclipse.swt.widgets.Widget::jsObject.self = this;
	$wnd.dojo.connect(
		self.@org.eclipse.swt.widgets.Widget::jsObject.domNode,
		eventType,
		function(e){ 
			e.preventDefault();			
			self.@org.eclipse.swt.widgets.Widget::jsObject.beginSizing(e);			 
		}
	);
}-*/;

}
